% ex3_62.m
% example 3.6.2 (p. 56)
% Figs. 3.7 & 3.8
clear
N=50;
R=4;
Q=0.64/100;
F=[1  1 0.5 0.5;
   0  1  1   1;
   0  0  1   0;
   0  0  0   0.606];
GT=[0 0 0 1];
G=GT';
H=[1 0 0 0];
[p,n]=size(H);  %
m=size(GT,1);   %  n, m, p are obtained from data matrices
% 
t=0:1:N;
x=zeros(n,N+1);
v=sqrt(R)*randn(p,N+1);
w=sqrt(Q)*randn(m,N+1);
y=zeros(p,N+1);
x(:,1)=[1.25 0.06 0.01 -0.003]';
% data generation
for i=1:N
x(:,i+1)= F*x(:,i)+ G*w(:,i);
y(:,i)=H*x(:,i) + v(:,i);
end
y(:,N+1)=H*x(:,N+1) + v(:,N+1);
% Kalman filter
xep=zeros(n,N+1);     % prediction x_{t/t-1}
xef=zeros(n,N+1);     % filtering  x_{t/t}
Pep=zeros(n,n,N+1);   % variance of prediction P_{t/t-1}
Pef=zeros(n,n,N+1);   % variance of filtering P_{t/t}
Pes=zeros(n,n,N+1);   % variance of smoothing P_{t/N}
Pep(:,:,1)=[10 0 0 0;
    0 10 0 0;
    0 0 10 0;
    0 0 0 10]; % initial covariance of prediction
xep(:,1)=[0 0 0 0]';
for i=1:N
% filtering    
hp=H*Pep(:,:,i);
d=hp*H' + R;
K=Pep(:,:,i)*H'*inv(d);   
Pef(:,:,i)=Pep(:,:,i)-K*d*K';
xef(:,i)=xep(:,i) + K*(y(:,i)-H*xep(:,i));    
% prediction
Pep(:,:,i+1)=F*Pef(:,:,i)*F' + G*Q*G';   
xep(:,i+1)=F*xef(:,i);        
end
d=H*Pep(:,:,N+1)*H' + R;
K=Pep(:,:,N+1)*H'*inv(d);  
Pef(:,:,N+1)=Pep(:,:,N+1) - K*d*K';  
xef(:,N+1)=xep(:,N+1) + K*(y(:,N+1)-H*xep(:,N+1));
% smoothing
xes=zeros(n,N+1);  % smoothed estimate
Pes=zeros(n,n,N+1);
xes(:,N+1)=xef(:,N+1);       % bundary value at t=N+1
Pes(:,:,N+1)=Pef(:,:,N+1);   % bundary value at t=N+1
for k=N+1:-1:2
Cs = Pef(:,:,k-1)*F'/Pep(:,:,k);                 % (3.36)
xes(:,k-1)= xef(:,k-1)+Cs*(xes(:,k)-xep(:,k));   % (3.35)
Pes(:,:,k-1)= Pef(:,:,k-1)+Cs*(Pes(:,:,k)-Pep(:,:,k))*Cs'; % (3.37)
end
% filtering and smoothing errors
ef=xef(1,:)-x(1,:); varf=var(ef)  
es=xes(1,:)-x(1,:); vars=var(es)  

figure(1)
plot(t,x(1,1:N+1),'r-',t,y(1,1:N+1),'g-x',t,xef(1,1:N+1),...
    'k^-',t,xes(1,1:N+1),'bo-','LineWidth',1.4)
legend('True x_t','Observation y_t',...
    'Filtered estimate x_{t/t}^{(1)}',...
    'Smoothed estimate x_{t/N}^{(1)}')
xlabel('Number of steps t')
ylabel('Smoothing')
title('Fig. 3.7: Filtering and smoothing')
grid

Pef2(1,:)=Pef(1,1,:); Pes2(1,:)=Pes(1,1,:);
figure(2)
plot(t,Pef2(1,1:N+1),'k^',t,Pes2(1,1:N+1),'bo',...
    'LineWidth',1.4)
legend('Filtered variance P_{t/t}^{(11)}',...
    'Smoothed variance P_{t/N}^{(11)}')
xlabel('Number of steps t')
title('Fig. 3.8: Variances of filtering and smoothing')
grid

figure(3)
plot(t,x(3,1:N+1),'r',t,xef(3,1:N+1),'b','LineWidth',1.4)
xlabel('Number of steps t')
ylabel('Estimate of x_t^{(3)}')
legend('True x^{(3)}=0.01','Estimate of x_{t}^{(3)}')
title('Fig. 3.9')
grid

